/** @file   TankBullet.h
 * @brief   Declaration of TankBullet class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:42 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_TANKBULLET_H
#define H_WWW_TANKBULLET_H

#include "bullet.h"

namespace WeWantWar {

/** @class  TankBullet
 * @brief   Represents the cannonball shot by the Tank
 * @author  Tomi Lamminsaari
 *
 */
class TankBullet : public Bullet
{
public:

  ///
  /// Constants, datatypes and static methods
  /// =======================================

  ///
  /// Constructors, destructor and operators
  /// ======================================

  /** Default constructor.
   * @param   aShooter          Pointer to GameObject who shot this bullet.
   * @param   aPos              Starting position.
   */
  TankBullet( GameObject* aShooter, const eng2d::Vec2D& aPos );

  /** Destructor
   */
  ~TankBullet();

private:
  
  /** Copy constructor
   * @param   aAnother          Reference to another TankBullet
   */
  TankBullet( const TankBullet& aAnother );

  /** An assignment operator
   * @param   aAnother          Reference to another TankBullet
   * @return  Reference to this object.
   */
  TankBullet& operator= ( const TankBullet& aAnother );

public:

  ///
  /// Inherited methods
  /// =================

  /** Draws this bullet.
   * @param   aBitmap           pointer to target bitmap.
   */
  virtual void redraw( BITMAP* aBitmap ) const;

  /** Explodes this bullet.
   * @param   aBulletTable      Pointer to BulletTable where we spawn emitted
   *                            bullets.
   */
  virtual void endingActions( BulletTable* aBulletTable );
 
};

};  // end of namespace

#endif
